/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************//*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : QUAD S-R LATCHES
TRUTHTABLE     : 
      ---------------  
       _    _   
       S+   R      Q
      ---------------
       H    H      QO
       L    H      H
       H    L      L
       L    L      H*
      ---------------   
      NOTES : 1. (+) FOR LATCHES WITH DOUBLE S INPUT :
                     H = BOTH S INPUTS HIGH
                     L = ONE OR BOTH INPUTS LOW
              2. (*) THIS CONFIGURATION IS NON STABLE.
                     IT MAY NOT PERSIST WHEN S & R RETURN TO THEIR
                     INACTIVE STATE.
       
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a279 (r1n, s11n, s12n, q1, r2n, s2n, q2, q3, r3n, s31n, s32n, q4, r4n, s4n);
	parameter size =1;
	parameter cds_action = "ignore";
	input
		r1n,
		s11n,
		s12n,
		r2n,
		s2n,
		r3n,
		s31n,
		s32n,
		r4n,
		s4n;
	output
		q1,
		q2,
		q3,
		q4;
    reg
        NOTIFY_REG4;
    reg
        NOTIFY_REG3;
    reg
        NOTIFY_REG2;
    reg
        NOTIFY_REG1;
    and
	A1 (en1, s11n, s12n);
    and
	A2 (en3, s31n, s32n);
    and
	M279N_P1_inst1_A1 (m279n_p1_inst1_sb_1, s11n, s12n);
    buf
	  (q1, m279n_p1_inst1_q_1int);
    U_L_SB_RB_NO_Q
	M279N_P1_inst1_inst1_U1 (m279n_p1_inst1_q_1int, m279n_p1_inst1_sb_1, r1n, NOTIFY_REG1);
    buf
	  (q2, m279n_p2_inst1_q_1int);
    U_L_SB_RB_NO_Q
	M279N_P2_inst1_inst1_U1 (m279n_p2_inst1_q_1int, s2n, r2n, NOTIFY_REG2);
    and
	M279N_P1_inst2_A1 (m279n_p1_inst2_sb_1, s31n, s32n);
    buf
	  (q3, m279n_p1_inst2_q_1int);
    U_L_SB_RB_NO_Q
	M279N_P1_inst2_inst1_U1 (m279n_p1_inst2_q_1int, m279n_p1_inst2_sb_1, r3n, NOTIFY_REG3);
    buf
	  (q4, m279n_p2_inst2_q_1int);
    U_L_SB_RB_NO_Q
	M279N_P2_inst2_inst1_U1 (m279n_p2_inst2_q_1int, s4n, r4n, NOTIFY_REG4);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
